import * as React from 'react';
import StaffCard from 'components/StaffCard';
import { FormattedDate } from 'react-intl';
import Button from '@crm/components/dist/lego2/Button';
import Icon from 'lego/components/Icon';
import Toolbar from 'components/Toolbar';
import cx from 'classnames';
import { ACTIONS } from '../../constants';
import { Timer as ITimer } from './types';
import css from './Timer.scss';

interface Props {
  timer: ITimer;
  className?: string;
  onRemove?: () => void;
  onEdit?: () => void;
}

const editIconProvider = (iconCls) => (
  <Icon className={iconCls} pack={Icon.PACKS.MATERIAL} icon="edit" />
);
const removeIconProvider = (iconCls) => (
  <Icon className={iconCls} pack={Icon.PACKS.MATERIAL} icon="delete" />
);

const Timer = (props: Props) => {
  const { timer, className, onRemove, onEdit } = props;
  const { startDate, author, comment, action } = timer;

  if (!timer) {
    return null;
  }

  return (
    <div className={cx(css.b, className)}>
      <div className={css.b__row}>
        <div>
          {startDate && (
            <div>
              <FormattedDate
                value={new Date(startDate)}
                year="numeric"
                month="numeric"
                day="numeric"
                hour="numeric"
                minute="numeric"
              />
            </div>
          )}
          <div>
            <StaffCard user={author} theme={StaffCard.THEME.YANDEX} />
          </div>
        </div>
        <Toolbar className={css.b__actions}>
          {onEdit && <Button size="xs" view="pseudo" onClick={onEdit} icon={editIconProvider} />}
          {onRemove && (
            <Button size="xs" view="danger" onClick={onRemove} icon={removeIconProvider} />
          )}
        </Toolbar>
      </div>

      <div className={css.b__row}>
        <div>
          {Boolean(action) && <div className={css.b__timerAction}>{ACTIONS[action]}</div>}
          {Boolean(comment) && <div className={css.b__comment}>{comment}</div>}
        </div>
      </div>
    </div>
  );
};

export default Timer;
