import * as React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import css from './Timers.scss';
import Timer from './Timer';
import { Modal } from '../Form';
import { Timer as ITimer } from './types';

interface Props {
  className?: string;
  items: ITimer[];
  size?: string;
  theme?: string;
  disabled?: boolean;
  onRemove: (id: number) => {};
  onAdd: (timer: ITimer) => {};
  onOpenModal: () => {};
  open: (args: any) => {};
}

class Timers extends React.Component<Props> {
  private handleOpen = (initialValues?: any) => {
    const { open, onAdd, onOpenModal } = this.props;

    if (typeof onOpenModal === 'function') {
      onOpenModal();
    }

    open({ initialValues, isNew: !initialValues, onSubmit: onAdd });
  };

  public render(): React.ReactElement {
    const { items, disabled, onRemove, className } = this.props;

    return (
      <div className={cx(className, css.b)}>
        {Array.isArray(items) && !!items.length && (
          <div className={css.b__list}>
            {items.map((item) => (
              <Timer
                key={item.id}
                timer={item}
                className={css.b__item}
                onRemove={disabled ? undefined : () => onRemove(item.id)}
                onEdit={disabled ? undefined : () => this.handleOpen(item)}
              />
            ))}
          </div>
        )}
        {!disabled && (
          <div className={css.b__footer}>
            <Button
              size="xs"
              view="pseudo"
              onClick={() => {
                this.handleOpen();
              }}
            >
              Создать
            </Button>
          </div>
        )}
      </div>
    );
  }
}

export default Modal.withOpen(Timers);
