import React from 'react';
import PropTypes from 'prop-types';
import Icon from 'components/Icons/Icon';
import css from './styles.modules.scss';
import Factor from './Factor';

const ICONS = {
  On: <Icon style={{ color: 'green' }} icon="play" title="Идут показы" />,
  Off: <Icon style={{ color: 'red' }} icon="stop" title="Остановлена" />,
  Rejected: (
    <Icon style={{ color: 'red' }} icon="exclamation-triangle" title="Отклонена модерацией" />
  ),
  Archived: <Icon icon="lock" title="Кампания в архиве" />,
};

const Campaign = ({ campaign, accountLogin, factors, ...props }) => {
  let factorsView;
  if (props.upsaleOff) {
    factorsView = 'Факторы скрыты';
  } else {
    factorsView = campaign.factors.map((f) => (
      <Factor
        key={f.id}
        factorCounters={f}
        factor={factors[f.id]}
        campaignId={campaign.campaignId}
        {...props}
      />
    ));
  }

  return (
    <div className={css.campaignFactors}>
      {campaign.campaignId && (
        <span className={css.campaignFactors_title}>
          {ICONS[campaign.status]}
          &nbsp;
          {campaign.campaignId}
          &nbsp;
          <a
            target="_blank"
            rel="noopener noreferrer"
            href={`https://direct.yandex.ru/registered/main.pl?cmd=showCamp&ulogin=${accountLogin}&cid=${campaign.campaignId}`}
          >
            {campaign.name || 'Директ'}
          </a>
          &nbsp;
        </span>
      )}
      {factorsView}
    </div>
  );
};

Campaign.propTypes = {
  accountId: PropTypes.number.isRequired,
  campaign: PropTypes.instanceOf(Object).isRequired,
  accountLogin: PropTypes.string,
  factors: PropTypes.instanceOf(Object).isRequired,
  upsaleOff: PropTypes.bool.isRequired,
};

export default Campaign;
