/* eslint-disable react/no-array-index-key */

import React from 'react';
import PropTypes from 'prop-types';
import Button from '@crm/components/dist/lego2/Button';
import { Overlay } from 'components/Overlay';
import UpsaleGroup from '../UpsaleGroup';
import css from './Layout.module.css';

const FactorBlocks = ({
  upsale,
  upsaleInfo,
  accountId,
  onFactorClick,
  factors,
  isLoadingUpsale,
  isSupportCopyToClipboard,
  isSupportSaveFactors,
  canCancelUpsale,
  accountLogin,
  saveFactors,
  cancelUpsale,
  getDefaultFactorState,
  clickDisabled,
  isFetchingToSaveDraft,
}) => {
  const upsaleOff = upsaleInfo && upsaleInfo.upsaleOff;
  const commonProps = {
    accountId,
    onFactorClick,
    factors,
    isSupportCopyToClipboard,
    accountLogin,
    saveRequestHash: upsale && upsale.saveRequestHash,
    getDefaultFactorState,
    clickDisabled,
    upsaleOff,
  };
  commonProps.maxFactorsCount = upsaleInfo && upsaleInfo.maxFactorsCount;
  const can = {
    cancelUpsale: canCancelUpsale && !upsaleOff,
    saveFactors: isSupportSaveFactors && !upsaleOff,
  };

  return (
    <div className={css.root}>
      {upsaleInfo && Array.isArray(upsaleInfo.factorGroups) && (
        <div>
          <div>
            {upsaleInfo.factorGroups.map((group, index) => (
              <UpsaleGroup key={index} group={group} {...commonProps} />
            ))}
          </div>

          <div className={css.b__saveRow}>
            {can.saveFactors && (
              <Button
                view="action"
                onClick={saveFactors}
                disabled={upsale.isFetchSave}
                progress={upsale.isFetchSave}
              >
                Сохранить
              </Button>
            )}
            {can.cancelUpsale && (
              <Button
                view="pseudo"
                onClick={cancelUpsale}
                disabled={upsale.isFetchSave}
                progress={upsale.isFetchSave}
              >
                Отменить
              </Button>
            )}
          </div>
        </div>
      )}

      <Overlay display={isLoadingUpsale || isFetchingToSaveDraft} />
    </div>
  );
};

export default FactorBlocks;

FactorBlocks.propTypes = {
  upsale: PropTypes.instanceOf(Object).isRequired,
  upsaleInfo: PropTypes.instanceOf(Object),
  onFactorClick: PropTypes.func.isRequired,
  getDefaultFactorState: PropTypes.func.isRequired,
  accountId: PropTypes.number.isRequired,
  factors: PropTypes.instanceOf(Object),
  isLoadingUpsale: PropTypes.bool.isRequired,
  saveFactors: PropTypes.func.isRequired,
  isSupportCopyToClipboard: PropTypes.bool,
  isSupportSaveFactors: PropTypes.bool,
  accountLogin: PropTypes.string,
  clickDisabled: PropTypes.bool,
};

FactorBlocks.defaultProps = {
  upsaleInfo: null,
  factors: [],
  isSupportCopyToClipboard: false,
  isSupportSaveFactors: false,
  accountLogin: undefined,
  clickDisabled: false,
};
