/* eslint-disable @typescript-eslint/no-explicit-any */
import { Component } from 'react';
import { FactorContextProps } from 'services/FactorService/FactorService';
import { FactorChangeCallback } from '../../types';

export interface LoadUpsaleData {
  accountId?: number;
  campaignId?: number;
  chatId?: number;
  issueId?: number;
  mode?: string;
}

export interface LayoutContainerProps extends LoadUpsaleData {
  upsale: any;
  resetUpsale();
  loadAllFactors(payload: {
    accountId?: number;
    campaignId?: number;
    chatId?: number;
    issueId?: number;
    ycCallId?: string;
    mode?: string;
  });
  onFactorChange?: FactorChangeCallback;
  factorStream: FactorContextProps;
}

declare class LayoutContainer extends Component<LayoutContainerProps> {
  protected reloadUpsale();
  protected load();
  updateFactorFilesAndTemplatesIfNeeded(previousProps: LayoutContainerProps);
}
