import {
  XivaContext,
  XivaBackendEvents,
  XivaBackendEventType,
  CRMXiva,
  BackendUpdateUpsaleData,
} from 'modules/xiva';
import { ETypeString } from 'types/entities';
import { LayoutContainer } from './LayoutContainer';

export class LayoutContainerWithXiva extends LayoutContainer {
  public static getXivaUpsaleIssueTag = (issueId: number): string => {
    return `${ETypeString.Issue}_${issueId}`;
  };

  public static contextType = XivaContext;

  private upsaleLoadData?: BackendUpdateUpsaleData;

  private xivaTag: string;

  componentDidMount() {
    this.xivaTag = LayoutContainerWithXiva.getXivaUpsaleIssueTag(this.props.issueId || 0);
    this.load();

    (this.context as CRMXiva).addTag(this.xivaTag);
    (this.context as CRMXiva).addEventListener(
      XivaBackendEventType.UpdateUpsale,
      this.handleXivaUpdateUpsaleEvent,
    );
  }

  componentDidUpdate(previousProps) {
    this.updateFactorsIfIssueChange(previousProps);
    this.updateFactorFilesAndTemplatesIfNeeded(previousProps);
  }

  componentWillUnmount(): void {
    if (super.componentWillUnmount) {
      super.componentWillUnmount();
    }

    (this.context as CRMXiva).removeTag(this.xivaTag);
    (this.context as CRMXiva).removeEventListener(
      XivaBackendEventType.UpdateUpsale,
      this.handleXivaUpdateUpsaleEvent,
    );
  }

  private updateFactorsIfIssueChange(previousProps) {
    if (this.props.issueId !== previousProps.issueId) {
      this.reloadUpsale();
    }
  }

  private handleXivaUpdateUpsaleEvent = (
    event: XivaBackendEvents[XivaBackendEventType.UpdateUpsale],
  ) => {
    this.upsaleLoadData = event.detail;

    this.reloadUpsale();
  };

  loadRequest() {
    return this.props.loadAllFactors({
      accountId: (this.upsaleLoadData && this.upsaleLoadData.accountId) || this.props.accountId,
      campaignId: this.props.campaignId,
      chatId: this.props.chatId,
      issueId: this.props.issueId,
      ycCallId: (this.upsaleLoadData && this.upsaleLoadData.ycCallId) || undefined,
      mode: this.props.mode,
    });
  }
}
