import { bindActionCreators } from 'redux';
import { connect } from 'react-redux';
import {
  getUpsaleState,
  getCallMailFiles,
  getCallMailContainerId,
  getCallMailId,
  getUpsaleFactors,
  getUpsaleInfo,
  getUpsaleIsLoading,
  getUpsaleFactorsSelected,
  getUpsaleIsUpdatingFiles,
  getMaxFactorsCount,
  isFetchingToSaveDraft,
} from '../../selectors';
import {
  actionsMailFileUpdateLinks,
  resetUpsale,
  loadAllFactors,
  toggleFactor,
  saveFactors,
  saveDraftFactors,
} from '../../actions';

const mapState = (state) => ({
  factors: getUpsaleFactors(state),
  upsaleInfo: getUpsaleInfo(state),
  mailFiles: getCallMailFiles(state),
  mailContainerId: getCallMailContainerId(state),
  mailId: getCallMailId(state),
  upsale: getUpsaleState(state),
  isLoadingUpsale: getUpsaleIsLoading(state),
  isFetchingToSaveDraft: isFetchingToSaveDraft(state),
  upsaleFactorsSelected: getUpsaleFactorsSelected(state),
  isUpdatingFiles: getUpsaleIsUpdatingFiles(state),
  maxFactorsCount: getMaxFactorsCount(state),
});

const mapDispatch = (dispatch, props) => ({
  ...bindActionCreators(
    {
      updateFactorFileLinks: actionsMailFileUpdateLinks,
      resetUpsale,
      loadAllFactors,
    },
    dispatch,
  ),
  toggleFactor: (factor, campaignId) => {
    dispatch(toggleFactor(props.accountId, factor.id, campaignId, factor.factorSource));
  },
  saveFactors: () => {
    const { accountId, chatId, issueId } = props;
    return dispatch(
      saveFactors({
        accountId,
        chatId,
        issueId,
      }),
    );
  },
  cancelUpsale: () => {
    const { accountId, issueId } = props;
    return dispatch(
      saveFactors({
        accountId,
        cancelled: true,
        issueId,
      }),
    );
  },
  saveDraftFactors: (factor, campaignId) => {
    return dispatch(
      saveDraftFactors({
        accountId: props.accountId,
        chatId: props.chatId,
        issueId: props.issueId,
        factorId: factor.id,
        campaignId,
        factorSource: factor.factorSource,
      }),
    );
  },
});

export default connect(mapState, mapDispatch);
