import * as React from 'react';
import css from './styles.modules.scss';
import Campaign from './Campaign';

export interface Block {
  title: React.ReactNode;
  // eslint-disable-next-line
  factorData?: any[];
}

interface Props {
  block: Block;
}

const UpsaleBlock = ({ block, ...props }: Props) => (
  <div className={css.factorBlock}>
    <div className={css.factorBlock_title}>
      <span>{block.title}</span>
    </div>
    <div className={css.factorBlock_campaigns}>
      {Array.isArray(block.factorData) &&
        block.factorData.map((c, index) => (
          <Campaign key={c.campaignId || index} campaign={c} {...props} />
        ))}
    </div>
  </div>
);

export default UpsaleBlock;
