/* eslint-disable react/no-array-index-key */

import * as React from 'react';
import UpsaleBlock, { Block } from './UpsaleBlock';
import css from './UpsaleGroup.modules.scss';

interface Group {
  title: React.ReactNode;
  blocks: Block[];
}

interface Props {
  group: Group;
}

const UpsaleGroup = (props: Props) => {
  const { group, ...passPropsThrough } = props;

  return (
    <div className={css.block}>
      <div className={css.block__title}>{group.title}</div>
      <div className={css.block__content}>
        {Object.values(group.blocks).map((block, index) => (
          <UpsaleBlock key={index} block={block} {...passPropsThrough} />
        ))}
      </div>
    </div>
  );
};

UpsaleGroup.defaultProps = {
  group: {},
};

export default UpsaleGroup;
