import reducerFactoryRaw from 'utils/reducer/reducerFactoryRaw';
import {
  TOGGLE_FACTOR,
  UPSALE_DATA_REQUEST,
  RESET_UPSALE,
  UPSALE_DATA_RECEIVE,
  UPSALE_DATA_FAILED,
  UPSALE_CAMPAIGN_RECEIVE,
  UPSALE_UPDATE_FILES_REQUEST,
  UPSALE_UPDATE_FILES_FINISH,
  UPSALE_SAVE_REQUEST,
  UPSALE_SAVE_RECEIVE,
  UPSALE_SAVE_REQUEST_FINISH,
  UPSALE_REPLACE_STATE,
  UPSALE_SAVE_DRAFT_REQUEST,
  UPSALE_SAVE_DRAFT_RECEIVE,
  UPSALE_SAVE_DRAFT_FAIL,
} from './actionTypes';
import { WITHOUT_CAMPAIGN_ID } from './constants';

const initialState = {
  selectedFactors: {},
  factors: [],
  isLoading: false,
  isFetchingToSaveDraft: false,
};

export const behaviors = {
  [TOGGLE_FACTOR](state, { payload }) {
    const newState = Object.assign({}, state);
    newState.lastFactor = { id: payload.factorId, campaignId: payload.campaignId };
    const { selectedFactors } = newState;
    const newSelectedFactors = { ...selectedFactors };
    newState.selectedFactors = newSelectedFactors;
    const campaignId = payload.campaignId || WITHOUT_CAMPAIGN_ID;
    if (!newSelectedFactors[payload.factorId]) {
      // Factor wasn't added before
      newSelectedFactors[payload.factorId] = { [campaignId]: true, length: 1 };
      newState.factors = [
        ...newState.factors,
        { id: payload.factorId, factorSource: payload.factorSource },
      ];
      newState.lastFactor.status = 'add';
    } else {
      const updateFactorCampaigns = { ...newSelectedFactors[payload.factorId] };
      if (updateFactorCampaigns[campaignId]) {
        // There is the factor with campaign (toggle OFF)
        if (updateFactorCampaigns.length > 1) {
          // Not only selected campaign in the factor
          delete updateFactorCampaigns[campaignId];
          updateFactorCampaigns.length -= 1;

          newSelectedFactors[payload.factorId] = updateFactorCampaigns;
        } else {
          // Only selected campaign in the factor, removing factor with campaign
          delete newSelectedFactors[payload.factorId];
          const index = newState.factors.findIndex((f) => f.id === payload.factorId);
          newState.factors = [
            ...newState.factors.slice(0, index),
            ...newState.factors.slice(index + 1),
          ];
          newState.lastFactor.status = 'remove';
        }
      } else {
        // Toggle ON
        updateFactorCampaigns[campaignId] = true;
        updateFactorCampaigns.length += 1;

        newSelectedFactors[payload.factorId] = updateFactorCampaigns;
      }
    }

    return newState;
  },
  [UPSALE_DATA_REQUEST](state) {
    return {
      ...state,
      isLoading: true,
    };
  },
  [UPSALE_DATA_RECEIVE](state, { data = {} }) {
    return {
      ...state,
      selectedFactors: data.selectedFactors,
      info: data,
      isLoading: false,
    };
  },
  [UPSALE_DATA_FAILED](state) {
    return {
      ...state,
      isLoading: false,
    };
  },

  [UPSALE_CAMPAIGN_RECEIVE](state, { data }) {
    return {
      ...state,
      info: data,
    };
  },
  [UPSALE_UPDATE_FILES_REQUEST](state) {
    return {
      ...state,
      isUpdatingFiles: true,
    };
  },
  [UPSALE_UPDATE_FILES_FINISH](state) {
    const newState = { ...state };
    delete newState.isUpdatingFiles;

    return newState;
  },
  [UPSALE_SAVE_REQUEST](state) {
    return {
      ...state,
      isFetchSave: true,
    };
  },
  [UPSALE_SAVE_REQUEST_FINISH](state) {
    return {
      ...state,
      isFetchSave: false,
    };
  },
  [UPSALE_SAVE_RECEIVE](state, { data }) {
    return {
      info: data,
      factors: [],
      selectedFactors: {},
      saveRequestHash: (state.saveRequestHash || 0) + 1,
    };
  },
  [UPSALE_REPLACE_STATE](state, { payload }) {
    return payload;
  },
  [UPSALE_SAVE_DRAFT_REQUEST](state) {
    return {
      ...state,
      isFetchingToSaveDraft: true,
    };
  },
  [UPSALE_SAVE_DRAFT_RECEIVE](state) {
    return {
      ...state,
      isFetchingToSaveDraft: false,
    };
  },
  [UPSALE_SAVE_DRAFT_FAIL](state) {
    return {
      ...state,
      isFetchingToSaveDraft: false,
    };
  },
  [RESET_UPSALE]() {
    return initialState;
  },
};

export default reducerFactoryRaw(null, behaviors, initialState);
