import get from 'lodash/get';
import { getFormValues } from 'redux-form';
import { CALL_MAIL_NAME } from 'modules/phone/constants';
import { NAME } from './constants';

export const getUpsaleInfo = (state) => get(state, `${NAME}.info`);
export const getUpsaleIsLoading = (state) => get(state, `${NAME}.isLoading`);
export const getUpsaleIsUpdatingFiles = (state) => get(state, `${NAME}.isUpdatingFiles`);
export const getUpsaleFactors = (state) => get(state, `${NAME}.info.factors`);
export const getUpsaleFactorsSelected = (state) => get(state, `${NAME}.factors`);
export const getUpsaleFactorsForOffer = (state) => get(state, `${NAME}.info.factorsForOffer`);
export const getMaxFactorsCount = (state) => get(state, `${NAME}.info.maxFactorsCount`);
export const getSelectedFactors = (state) => get(state, `${NAME}.selectedFactors`);
export const isFetchingToSaveDraft = (state) => get(state, `${NAME}.isFetchingToSaveDraft`);
export const getUpsaleState = (state) => get(state, NAME);

const getCallMailData = (state) => getFormValues(CALL_MAIL_NAME)(state) || {};
export const getCallMailFiles = (state) => getCallMailData(state).files;
export const getCallMailContainerId = (state) => getCallMailData(state).containerId;
export const getCallMailId = (state) => getCallMailData(state).id;
export const getUpsaleDraftId = (state) => get(state, `${NAME}.info.upsaleDraftId`);
