import { WITHOUT_CAMPAIGN_ID } from '../constants';

export default {
  frontendToBackend: factors => {
    if (!factors) {
      return null;
    }

    return Object.keys(factors).reduce((ac, factorId) => {
      const campaings = { ...factors[factorId] };
      delete campaings.length;

      if (campaings[WITHOUT_CAMPAIGN_ID]) {
        campaings[-1] = true;
        delete campaings[WITHOUT_CAMPAIGN_ID];
      }

      ac[factorId] = Object.keys(campaings);

      return ac;
    }, {});
  },
  backendToFrontend: factors => {
    if (!factors) {
      return null;
    }

    const newFactors = { ...factors };

    Object.keys(factors).forEach(key => {
      const campaings = newFactors[key];
      if (Array.isArray(campaings)) {
        newFactors[key] = campaings.reduce((ac, campaingId) => {
          if (campaingId === -1) {
            ac[WITHOUT_CAMPAIGN_ID] = true;
          } else {
            ac[campaingId] = true;
          }

          return ac;
        }, {});
        newFactors[key].length = campaings.length;
      } else {
        delete newFactors[key];
      }
    });

    return newFactors;
  },
};
