type ValidateRequest = (needValidate: boolean, ...args: unknown[]) => unknown;
interface ValidateRequestData {
  upsaleConfirmData?: {
    message?: string;
  };
}

let depth = 0;

export const retryValidateRequest = (
  data: ValidateRequestData,
  request: ValidateRequest,
  ...args: unknown[]
): void | ValidateRequestData | ReturnType<ValidateRequest> => {
  depth++;
  if (depth >= 2) {
    depth = 0;
    return data;
  }

  const message =
    typeof data === 'object' && data.upsaleConfirmData && data.upsaleConfirmData.message;
  if (typeof message === 'string' && message.length) {
    const isConfirmed = window.confirm(message);
    if (isConfirmed) {
      return request(false, ...args);
    }
    depth = 0;
    return;
  }

  depth = 0;
  return data;
};
