import React from 'react';
import PropTypes from 'prop-types';
import css from './styles.modules.scss';

const UserInfoData = (props) => {
  const { user, displayUser } = props;

  return (
    <div>
      {displayUser && (
        <div className={css.user}>
          <div className={css.name}>{user.name}</div>
          <div className={css.position}>{`Роль Стафф: ${user.position}`}</div>
          {user.mainRoleName && <div className={css.position}>{`Роль CRM: ${user.mainRoleName}`}</div>}
        </div>
      )}
      {props.children}
    </div>
  );
};

UserInfoData.propTypes = {
  user: PropTypes.shape({
    name: PropTypes.string.isRequired,
    position: PropTypes.string.isRequired,
  }),
  displayUser: PropTypes.bool,
};

UserInfoData.defaultProps = {
  user: {},
  displayUser: true,
};

export default UserInfoData;
