import React, { FC, ReactElement } from 'react';
import ToolTip from 'lego/components/ToolTip';
import { AvatarWithUpdate } from 'components/Avatar';
import DelegationWidget from 'modules/delegationWidget';
import { StatusSyncServiceComponent } from 'modules/userStatus';
import cx from 'classnames';
import { UserInfoProps } from './Info.types';
import { StatusDropdown } from './StatusDropdown';
import { StatusIcon } from './StatusIcon';
import { StatusProblemIcon } from './StatusProblemIcon';
import { StatusFlagList } from './StatusFlagList';
import { StatusProblemList } from './StatusProblemList';
import Info from '../Data';
import css from './Info.module.css';

const UserInfo: FC<UserInfoProps> = (props): ReactElement => {
  const { info, hasDelegation, isDelegation } = props;
  const { useUserStatuses } = info.features;

  return (
    <ToolTip
      padding="xs"
      className={cx(css.root, isDelegation ? css.isAlias : null)}
      hideDelay={100}
      wrapClassName={css.popup}
      tooltip={
        <Info user={info.realUser || info.user} displayUser={!isDelegation}>
          <DelegationWidget
            delegations={info.availableDelegations}
            realUser={info.realUser}
            user={info.user}
          />
          {useUserStatuses && <StatusDropdown className={css.root__statusDropdown} />}
          {useUserStatuses && <StatusFlagList />}
          {useUserStatuses && <StatusProblemList className={css.root__statusProblemList} />}
        </Info>
      }
    >
      <AvatarWithUpdate user={info.user} theme="round" size="header" />
      {hasDelegation && <i className={cx('material-icons', css.iconAlias)}>assignment_ind</i>}
      {useUserStatuses && <StatusProblemIcon className={css.root__statusProblemIcon} />}
      {useUserStatuses && <StatusIcon className={css.root__statusIcon} />}
      {useUserStatuses && <StatusSyncServiceComponent />}
    </ToolTip>
  );
};

export default UserInfo;
