import * as React from 'react';
import { connect } from 'react-redux';
import { get } from 'api/common';
import { config } from 'services/Config';
import {
  SetPayload,
  actions as moduleCountersActions,
  modules,
} from 'reducers/moduleCountersSlice';
import { AdaptiveIntervalByTabVisibility, Interval } from 'services/AdaptiveInterval';

export const USER_STATE = 'USER_STATE';

interface ModuleState {
  unread: number;
}

interface GetUserStatePayload {
  mail: ModuleState;
  notifications: ModuleState;
  issue: ModuleState;
}

const getUserState = () => (dispatch) =>
  get({ url: '/view/user/state', global: false }).then((payload: GetUserStatePayload) => {
    dispatch({ type: USER_STATE, payload });

    const setPayload: SetPayload = Object.keys(payload).reduce((acc, moduleName) => {
      const supportedModuleName = modules[moduleName];
      if (!supportedModuleName) {
        return acc;
      }
      acc[supportedModuleName] = payload[moduleName].unread as number;
      return acc;
    }, {});
    dispatch(moduleCountersActions.set(setPayload));
  });

interface Props {
  getUserState: () => {};
}

class UserState extends React.Component<Props> {
  private interval: Interval;

  public componentDidMount() {
    this.props.getUserState();
    this.interval = new AdaptiveIntervalByTabVisibility(
      this.props.getUserState,
      config.value.config.intervals.viewUserState,
    );
  }

  public componentWillUnmount() {
    this.interval.destroy();
  }

  public render() {
    return null;
  }
}

export default connect(null, { getUserState })(UserState);
