import { connect, MapStateToProps } from 'react-redux';
import { Diff } from 'utils/DiffGeneric';
import { StatusStoreState, Dispatch } from '../Status.types';
import { selectors, actions } from '../Status.slice';
import {
  ConnectedStateDropdownProps,
  DropdownProps,
  ConnectedDispatchDropdownProps,
} from './Dropdown.types';

type RemainingProps = Diff<
  DropdownProps,
  ConnectedStateDropdownProps & ConnectedDispatchDropdownProps
>;

const mapStateToProps: MapStateToProps<
  ConnectedStateDropdownProps,
  RemainingProps,
  StatusStoreState
> = (state) => ({
  status: selectors.getCurrentStatus(state),
  transitions: selectors.getTransitions(state),
  disabled: selectors.isFetching(state),
});

const mapDispatchToProps = (dispatch: Dispatch): ConnectedDispatchDropdownProps => ({
  onChange: (status) => {
    dispatch(actions.setStatus({ status }));
  },

  getStatus: () => {
    dispatch(actions.getStatus());
  },
});

export default connect(mapStateToProps, mapDispatchToProps);
