import cx from 'classnames';
import { Option } from '@yandex-lego/components/Select/desktop';
import { UserStatus as Status } from 'types/UserStatus';
import { UserStatusId } from 'types/UserStatusId';
import { statusModClassName } from '../Status.helpers';
import { BLOCK_NAME } from './Dropdown.constants';

const map = {
  [UserStatusId.available]: cx(BLOCK_NAME, statusModClassName(BLOCK_NAME, UserStatusId.available)),
  [UserStatusId.workload]: cx(BLOCK_NAME, statusModClassName(BLOCK_NAME, UserStatusId.workload)),
  [UserStatusId.acw]: cx(BLOCK_NAME, statusModClassName(BLOCK_NAME, UserStatusId.acw)),
  [UserStatusId.sidework]: cx(BLOCK_NAME, statusModClassName(BLOCK_NAME, UserStatusId.sidework)),
  [UserStatusId.lunch]: cx(BLOCK_NAME, statusModClassName(BLOCK_NAME, UserStatusId.lunch)),
  [UserStatusId.shortbreak]: cx(
    BLOCK_NAME,
    statusModClassName(BLOCK_NAME, UserStatusId.shortbreak),
  ),
  [UserStatusId.meeting]: cx(BLOCK_NAME, statusModClassName(BLOCK_NAME, UserStatusId.meeting)),
  [UserStatusId.forcedPause]: cx(
    BLOCK_NAME,
    statusModClassName(BLOCK_NAME, UserStatusId.forcedPause),
  ),
  [UserStatusId.disconnected]: cx(
    BLOCK_NAME,
    statusModClassName(BLOCK_NAME, UserStatusId.disconnected),
  ),
};
export const getRootClassName = (status: Status | undefined): string => {
  if (status) {
    return map[status.id];
  }

  return BLOCK_NAME;
};

export const status2Option = (status: Status): Option => ({
  value: String(status.id),
  content: status.text,
});
