import React, { PureComponent, ReactNode } from 'react';
import Select from '@crm/components/dist/lego2/Select';
import cx from 'classnames';
import { UserStatus as Status } from 'types/UserStatus';
import { UserStatusId } from 'types/UserStatusId';
import { DropdownProps } from './Dropdown.types';
import { getRootClassName, status2Option } from './Dropdown.helpers';
import { BLOCK_NAME } from './Dropdown.constants';
import './Dropdown.css';

class Dropdown extends PureComponent<DropdownProps> {
  private onChange = (stringStatusId: string): void => {
    const { onChange, transitions } = this.props;
    if (!onChange) {
      return;
    }

    const statusId: UserStatusId = Number(stringStatusId);
    onChange(transitions.find((transition): boolean => transition.id === statusId) as Status);
  };

  public render(): ReactNode {
    const { status, transitions, className, disabled } = this.props;
    const rootClassName = getRootClassName(status);

    return (
      <div className={cx(rootClassName, className)}>
        <Select
          className={cx(`${BLOCK_NAME}__select`, {
            [`${BLOCK_NAME}__select_empty`]: !transitions.length,
          })}
          hasEmptyValue={false}
          disabled={disabled || !transitions.length}
          placeholder={status && status.text}
          options={transitions.map(status2Option)}
          onChange={this.onChange}
        />
      </div>
    );
  }
}

export default Dropdown;
