import React from 'react';
import { Checkbox } from 'components/design/Checkbox';
import css from './Flag.module.css';
import { FlagProps } from './Flag.types';

export const Flag: React.FC<FlagProps> = ({ name, value, text, onFlagChange }) => {
  const handleChange = () => {
    onFlagChange({ name, value: !value });
  };

  return (
    <div className={css.b}>
      <Checkbox checked={value} onChange={handleChange} />
      <span className={css.b__text}>{text}</span>
    </div>
  );
};
