import { connect, MapStateToProps } from 'react-redux';
import { StatusStoreState, Dispatch } from '../Status.types';
import { selectors, actions } from '../Status.slice';
import {
  ConnectedStateFlagListProps,
  FlagListProps,
  ConnectedDispatchFlagListProps,
} from './FlagList.types';

const mapStateToProps: MapStateToProps<
  ConnectedStateFlagListProps,
  FlagListProps,
  StatusStoreState
> = (state) => {
  return {
    isLoading: selectors.isFetching(state),
    flags: selectors.getFlags(state),
  };
};

const mapDispatchToProps = (dispatch: Dispatch): ConnectedDispatchFlagListProps => ({
  onChange: (flags) => {
    dispatch(actions.setStatus({ flags }));
  },
});

export default connect(mapStateToProps, mapDispatchToProps);
