import React from 'react';
import Spinner from 'components/Spinner';
import { Flag } from './Flag';
import { FlagListProps } from './FlagList.types';
import { Flag as UserFlag } from '../Status.types';
import css from './FlagList.module.css';

export const FlagList: React.FC<FlagListProps> = ({ isLoading, flags, onChange }) => {
  const handleFlagChange = (flag: Omit<UserFlag, 'text'>) => {
    if (onChange) {
      onChange([flag]);
    }
  };

  return (
    <React.Fragment>
      {flags?.map((flag) => (
        <Flag key={flag.name} {...flag} onFlagChange={handleFlagChange} />
      ))}
      {isLoading && (
        <div className={css.b__spin}>
          <Spinner visible modal={false} />
        </div>
      )}
    </React.Fragment>
  );
};
