import { connect } from 'react-redux';
import { Diff } from 'utils/DiffGeneric';
import { ConnectedStateIconProps, IconProps } from './Icon.types';
import { StatusStoreState } from '../Status.types';
import { selectors } from '../Status.slice';

type RemainingProps = Diff<IconProps, ConnectedStateIconProps>;

const mapStateToProps = (state: StatusStoreState): ConnectedStateIconProps => {
  const status = selectors.getCurrentStatus(state);
  return {
    status: status ? status : null,
  };
};

export default connect<ConnectedStateIconProps, {}, RemainingProps, StatusStoreState>(
  mapStateToProps,
);
