import React, { PureComponent, ReactNode } from 'react';
import { UserStatusIcon } from 'components/UserStatusIcon';
import { IconProps } from './Icon.types';

class Icon extends PureComponent<IconProps> {
  public render(): ReactNode {
    const { status, className } = this.props;
    if (status) {
      return <UserStatusIcon status={status} className={className} />;
    }

    return null;
  }
}

export default Icon;
