import { connect } from 'react-redux';
import { Diff } from 'utils/DiffGeneric';
import { ConnectedStateProblemIconProps, ProblemIconProps } from './ProblemIcon.types';
import { StatusStoreState } from '../Status.types';
import { selectors } from '../Status.slice';

type RemainingProps = Diff<ProblemIconProps, ConnectedStateProblemIconProps>;

const mapStateToProps = (state: StatusStoreState): ConnectedStateProblemIconProps => {
  return {
    problems: selectors.getProblems(state),
  };
};

export default connect<ConnectedStateProblemIconProps, {}, RemainingProps, StatusStoreState>(
  mapStateToProps,
);
