import React from 'react';
import cx from 'classnames';
import Button from '@crm/components/dist/lego2/Button';
import { ProblemProps } from './Problem.types';
import css from './Problem.module.css';

export const Problem: React.FC<ProblemProps> = ({ className, problem, actions }) => {
  return (
    <div className={cx(className, css.Problem)}>
      <div className={css.Problem__containerText}>{problem.text}</div>
      {actions?.map((action) => (
        <Button
          key={action.id}
          view="raised"
          onClick={() => {
            action.onClick(problem);
          }}
        >
          {action.text}
        </Button>
      ))}
    </div>
  );
};
