import { connect, MapStateToProps } from 'react-redux';
import { StatusStoreState, Dispatch } from '../Status.types';
import { selectors, actions } from '../Status.slice';
import {
  ConnectedStateProblemListProps,
  ProblemListProps,
  ConnectedDispatchProblemListProps,
} from './ProblemList.types';

const mapStateToProps: MapStateToProps<
  ConnectedStateProblemListProps,
  ProblemListProps,
  StatusStoreState
> = (state) => {
  return {
    problems: selectors.getProblems(state),
  };
};

const mapDispatchToProps = (dispatch: Dispatch): ConnectedDispatchProblemListProps => ({
  onFixProblems: (problems) => {
    dispatch(actions.setStatus({ problems }));
  },
});

export default connect(mapStateToProps, mapDispatchToProps);
