import React from 'react';
import cx from 'classnames';
import { UserProblem, UserProblemAnyAction } from 'types/UserStatus';
import { Problem, ProblemAction } from './Problem';
import { ProblemListProps } from './ProblemList.types';
import { handleTabRefresh } from './ProblemList.utils';
import css from './ProblemList.module.css';

export const ProblemList: React.FC<ProblemListProps> = ({ className, problems, onFixProblems }) => {
  const handleFixProblem = (problem: UserProblem) => {
    const { name } = problem;
    onFixProblems?.([{ name }]);
  };

  const getActions = (actions?: UserProblemAnyAction[]): ProblemAction[] => {
    return (
      actions?.map((action) => {
        switch (action.type) {
          case 'TabRefresh':
            return {
              text: 'Обновить страницу',
              onClick: handleTabRefresh,
              ...action,
            };
          case 'Fixed':
            return {
              text: 'Вернуться на линию',
              onClick: handleFixProblem,
              ...action,
            };
        }
      }) || [
        {
          text: 'Вернуться на линию',
          onClick: handleFixProblem,
        },
      ]
    );
  };

  if (!problems || problems.length === 0) return null;

  return (
    <div className={cx(css.ProblemList, className)}>
      <span className={css.ProblemList__title}>Требуются действия</span>
      {problems.map((problem) => (
        <Problem key={problem.name} problem={problem} actions={getActions(problem.actions)} />
      ))}
    </div>
  );
};
