import { get, jsonApiCall } from 'api/common';
import { BackendStatus } from 'modules/xiva';
import { Endpoint, Endpoints, EndpointRequest, Status, Flag, Problem } from './Status.types';

const createRequest = <TParams, TRes>(endpoint: Endpoint): EndpointRequest<TParams, TRes> => {
  const { url, method } = endpoint;
  return (params) => {
    if (method === 'GET') {
      return get({ url });
    }

    return jsonApiCall({ url, ...params });
  };
};

const endpoints: Endpoints = {
  GET_STATUS: {
    url: '/user/status',
    method: 'GET',
  },

  SET_STATUS: {
    url: '/user/status',
    method: 'POST',
  },
};

const getStatus = createRequest<undefined, BackendStatus>(endpoints.GET_STATUS);

const setStatus = createRequest<
  {
    data: {
      id?: number;
      statusId?: number;
      flags?: Flag[];
      problems?: Pick<Problem, 'name'>[];
    };
    global: false;
  },
  {
    status: Status;
    transitions: Status[];
    flags?: Flag[];
    problems?: Problem[];
  }
>(endpoints.SET_STATUS);

export default {
  getStatus,
  setStatus,
};
