import { BackendStatus } from 'modules/xiva';
import { UserStatusId } from 'types/UserStatusId';
import { Flag, Status, Problem } from './Status.types';

export const statusStub: Status = {
  id: UserStatusId.available,
  text: 'status text',
  icon: 'status icon',
  color: 'status color',
};

export const transitionStub: Status = {
  id: UserStatusId.lunch,
  text: 'transition text',
  icon: 'transition icon',
  color: 'transition color',
};

export const flagStub: Flag = {
  name: 'flag name',
  text: 'flag text',
  value: false,
};

export const problemStub: Required<Problem> = {
  name: 'problem name',
  text: 'problem text',
  actions: [
    {
      id: 'id',
      type: 'Fixed',
    },
  ],
};

export const responseStub: Required<BackendStatus> = {
  status: statusStub,
  transitions: [transitionStub],
  flags: [flagStub],
  problems: [problemStub],
};
