import Bluebird from 'bluebird';
import { UserStatus as Status } from 'types/UserStatus';
import { UserFlag as Flag } from 'types/UserStatus';
import { UserProblem as Problem } from 'types/UserStatus';

export { Status, Flag, Problem };

export interface WithShouldSendNextRequest {
  shouldSendNextRequest: boolean;
}

export interface StatusStoreState {
  status: SliceState;
}

export interface Dispatch {
  (action: object): void;
  (dispatch: (action: object) => void, getState: GetState): Promise<void>;
}

export interface GetState {
  (): StatusStoreState;
}

export interface SliceState {
  isFetching: boolean;
  current: Status | undefined;
  transitions: Status[];
  flags?: Flag[];
  problems?: Problem[];
}

type EndpointMethod = 'POST' | 'GET';
export interface Endpoint {
  url: string;
  method: EndpointMethod;
}
export interface Endpoints {
  [key: string]: Endpoint;
}

export type EndpointRequest<TParams extends {}, TRes extends {}> = (
  params?: TParams,
) => Bluebird<TRes>;
