import { useEffect, useContext } from 'react';
import { useStore } from 'react-redux';
import { XivaContext } from 'modules/xiva';
import { StatusSyncService } from '../services/StatusSyncService';

export const StatusSyncServiceComponent = () => {
  const xiva = useContext(XivaContext);
  const store = useStore();

  useEffect(() => {
    const statusSyncService = new StatusSyncService(store, xiva);
    return () => {
      statusSyncService.destroy();
    };
  }, [store, xiva]);

  return null;
};
