import { batch } from 'react-redux';
import { Store } from 'redux';
import { CRMXiva, XivaBackendEventType, XivaBackendEvents, BackendStatus } from 'modules/xiva';
import { StatusStoreState } from '../Status.types';
import { actions } from '../Status.slice';

export class StatusSyncService {
  constructor(private store: Store<StatusStoreState>, private xiva: CRMXiva) {
    this.init();
  }

  private init() {
    this.xiva.addEventListener(XivaBackendEventType.Status, this.handleStatus);
  }

  private handleStatus = (event: XivaBackendEvents[XivaBackendEventType.Status]) => {
    this.updateStatus(event.detail);
  };

  private updateStatus(data: BackendStatus) {
    const { status, transitions, flags, problems } = data;
    batch(() => {
      if (status) {
        this.store.dispatch(actions.setCurrent(status));
      }

      if (transitions) {
        this.store.dispatch(actions.setTransitions(transitions));
      }

      if (flags) {
        this.store.dispatch(actions.setFlags(flags));
      }

      if (problems) {
        this.store.dispatch(actions.setProblems(problems));
      }
    });
  }

  public destroy() {
    this.xiva.removeEventListener(XivaBackendEventType.Status, this.handleStatus);
  }
}
