import React from 'react';
import { observer } from 'mobx-react-lite';
import { activeCallIssueService } from 'services/ActiveCallIssueService';
import { LinkToParentIssue } from '../LinkToParentIssue';
import { ActiveCallIssueLinkProps } from './ActiveCallIssueLink.types';

export const ActiveCallIssueLink = observer<ActiveCallIssueLinkProps>((props) => {
  if (!activeCallIssueService.issue) {
    return null;
  }

  return <LinkToParentIssue issue={activeCallIssueService.issue} {...props} />;
});
