import React, { FC, useEffect } from 'react';
import { WebphoneOutgoingEventKind } from '@yandex-telephony/ya-calls-webphone-sdk';
import { callLockContext } from './callLockContext';
import { CallLockProviderProps } from './CallLockProvider.types';
import { callLockService } from './callLockService';

export const CallLockProvider: FC<CallLockProviderProps> = ({ webphone, children }) => {
  useEffect(() => {
    if (!webphone) {
      return;
    }

    const handleCallEnd = () => {
      callLockService.release();
    };

    webphone.addEventListener(WebphoneOutgoingEventKind.CallEnd, handleCallEnd);

    return () => {
      webphone.removeEventListener(WebphoneOutgoingEventKind.CallEnd, handleCallEnd);
    };
  }, [webphone]);

  return <callLockContext.Provider value={callLockService}>{children}</callLockContext.Provider>;
};
