import { ComponentType } from 'react';
import { WebphoneWidget } from '@yandex-telephony/ya-calls-webphone-sdk';
import { CallMetaService, CallMeta, CallAvailableService } from '../../types';

export interface CallToAsProps {
  disabled?: boolean;
  onClick?: () => void;
}

export interface CallInitProps {
  webphone: WebphoneWidget;
  meta: CallMeta;
}

export type OnCallInit = (props: CallInitProps) => void;

export interface CallToProps {
  caller?: string;
  callee: string;
  associatedUnitId?: string;
  callMetaService: CallMetaService;
  callAvailableService: CallAvailableService;
  as?: ComponentType<CallToAsProps> | 'button';
  onCallInit?: OnCallInit;
  onCallError?: (error: Error) => void;
}
