import React, { FC } from 'react';
import { Link, useRouteMatch } from 'react-router-dom';
import cx from 'classnames';
import createLink from 'modules/issues/utils/createLink';
import { LinkToParentIssueProps } from './LinkToParentIssue.types';
import css from './LinkToParentIssue.module.css';

export const LinkToParentIssue: FC<LinkToParentIssueProps> = ({ className, issue, ...other }) => {
  const issueLink = createLink({ ...issue, hash: false });

  const match = useRouteMatch(issueLink);

  if (match) {
    return null;
  }

  return (
    <Link {...other} className={cx(className, css.LinkToParentIssue)} to={issueLink}>
      Ссылка на тикет
    </Link>
  );
};
