import React, { useContext, useCallback, FC } from 'react';
import { Webphone } from './WebphoneWithEnv';
import { WebphoneProps } from './Webphone.types';
import { webphoneSetterContext } from '../WebphoneContext/WebphoneContext';

export const WebphoneWithProvider: FC<Pick<WebphoneProps, 'onSwitchVisibility'>> = (props) => {
  const setter = useContext(webphoneSetterContext);
  const onInit = useCallback(
    (webphone) => {
      setter.setWebphone(webphone);
    },
    [setter],
  );

  const onDestroy = useCallback(() => {
    setter.setWebphone(null);
  }, [setter]);

  return <Webphone onInit={onInit} onDestroy={onDestroy} {...props} />;
};
