import React, { FC, useContext, useCallback } from 'react';
import Button, { ButtonProps } from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import { webphoneContext } from '../WebphoneContext/WebphoneContext';

const icon = (cls: string) => <Icon className={cls} svg="phone" />;

export const WebphoneButton: FC<ButtonProps> = (props) => {
  const webphone = useContext(webphoneContext);

  const handleOpenWebphone = useCallback(() => {
    if (webphone) {
      webphone.switchVisibility(true);
    }
  }, [webphone]);

  return (
    <Button
      onClick={handleOpenWebphone}
      pin="circle-circle"
      size="l"
      view="success"
      icon={icon}
      {...props}
    />
  );
};
