import { WebphoneWidget } from '@yandex-telephony/ya-calls-webphone-sdk';
import React, { createContext } from 'react';
import { config } from 'services/Config';
import { WebphoneStateProvider } from '../WebphoneStateContext/WebphoneStateProvider';
import { CallStatusServiceComponent } from '../CallStatusServiceComponent';
import { CallLockProvider } from '../CallLockContext';

interface WebphoneSetterContext {
  setWebphone: (webphone: Nullable<WebphoneWidget>) => void;
}

export const webphoneContext = createContext<WebphoneWidget | null>(null);
export const webphoneSetterContext = createContext<WebphoneSetterContext>({
  setWebphone: () => {},
});

interface WebphoneProviderState {
  webphone: Nullable<WebphoneWidget>;
}

export class WebphoneProvider extends React.Component<{}, WebphoneProviderState> {
  constructor(props) {
    super(props);

    this.state = { webphone: null };

    this.webphoneSetterContext = { setWebphone: this.setWebphone };
  }

  private webphoneSetterContext: WebphoneSetterContext;

  private setWebphone = (webphone: WebphoneWidget | null) => {
    this.setState({ webphone });
  };

  render() {
    return (
      <webphoneSetterContext.Provider value={this.webphoneSetterContext}>
        <webphoneContext.Provider value={this.state.webphone}>
          <WebphoneStateProvider webphone={this.state.webphone}>
            {config.value.features.useYaCalls ? (
              <CallLockProvider webphone={this.state.webphone}>
                {this.props.children}
                <CallStatusServiceComponent webphone={this.state.webphone} />
              </CallLockProvider>
            ) : (
              this.props.children
            )}
          </WebphoneStateProvider>
        </webphoneContext.Provider>
      </webphoneSetterContext.Provider>
    );
  }
}
