import React, { FC, useContext, useEffect, useState } from 'react';
import { config } from 'services/Config';
import Webphone from '../Webphone';
import { WebphoneButton } from '../WebphoneButton/WebphoneButton';
import { LinkToParentIssue } from '../LinkToParentIssue';
import { WebphoneFloatProps } from './WebphoneFloat.types';
import css from './WebphoneFloat.module.css';
import { webphoneContext } from '../WebphoneContext/WebphoneContext';
import webphoneStateContext from '../WebphoneStateContext/webphoneStateContext';
import { ActiveCallIssueLink } from '../ActiveCallIssueLink';

export const WebphoneFloat: FC<WebphoneFloatProps> = () => {
  const webphoneState = useContext(webphoneStateContext);
  const webphone = useContext(webphoneContext);

  const hasActiveCall = Boolean(webphoneState.call);
  const [isVisibleWebphone, setVisibleWebphone] = useState(false);

  useEffect(() => {
    if (!webphone) {
      return;
    }

    try {
      webphone.switchVisibility(hasActiveCall);
    } catch (error) {
      /* if webphone is not initialized */
    }
  }, [hasActiveCall, webphone]);

  return (
    <div className={css.WebphoneFloat} hidden={!(hasActiveCall || isVisibleWebphone)}>
      {config.value.features.useYaCalls && isVisibleWebphone && webphoneState.issue && (
        <LinkToParentIssue className={css.WebphoneFloat__issueLink} issue={webphoneState.issue} />
      )}
      {config.value.features.useYaCallsLB && isVisibleWebphone && (
        <ActiveCallIssueLink className={css.WebphoneFloat__issueLink} />
      )}
      <Webphone onSwitchVisibility={setVisibleWebphone} />
      {!isVisibleWebphone && <WebphoneButton />}
    </div>
  );
};
