import React from 'react';
import memoize from 'memoize-one';
import { WebphoneWidget } from '@yandex-telephony/ya-calls-webphone-sdk';
import { webphoneStateManager, WebphoneStateManager } from '../../services/WebphoneStateManager';
import webphoneStateContext from './webphoneStateContext';
import { WebphoneStateProviderProps } from './WebphoneStateProvider.types';

export class WebphoneStateProvider extends React.PureComponent<WebphoneStateProviderProps> {
  private webphoneStateManager: WebphoneStateManager;

  private initWebphoneStateManager = memoize((webphone: Nullable<WebphoneWidget>) => {
    this.webphoneStateManager = webphoneStateManager;
    if (webphone) {
      this.webphoneStateManager.setWebphone(webphone);
    }

    this.webphoneStateManager.onstateupdate = () => {
      this.forceUpdate();
    };
  });

  public render() {
    this.initWebphoneStateManager(this.props.webphone);

    return (
      <webphoneStateContext.Provider value={this.webphoneStateManager.state}>
        {this.props.children}
      </webphoneStateContext.Provider>
    );
  }
}
