import { jsonApiCall, get } from 'api/common';

interface CallStatusData {
  isInCall: boolean;
  callId: string;
}

interface CanCallData {
  canCall: boolean;
  message?: string;
}

export class CallStatusService {
  static readonly send = (data: CallStatusData) =>
    jsonApiCall({ url: '/yacalls/callStatus', data, global: false });

  public startCall(callId: string) {
    return CallStatusService.send({ isInCall: true, callId });
  }

  public endCall(callId: string) {
    return CallStatusService.send({ isInCall: false, callId });
  }

  public canCall = () => get<CanCallData>({ url: '/yacalls/canCall', global: false });
}
