export class StateManager<State> {
  public state: State;

  constructor(state: State) {
    this.state = state;
  }

  public onstateupdate: ((state: State) => void) | undefined;

  public setState(update: Partial<State>) {
    this.state = { ...this.state, ...update };

    if (this.onstateupdate) {
      this.onstateupdate(this.state);
    }
  }
}
