import {
  WebphoneOutgoingEventKind,
  WebphoneWidget,
  WebphoneNewIncomingCallEvent,
  WebphoneNewOutgoingCallEvent,
  WebphoneEstablishedCallEvent,
  WebphoneCallEndEvent,
} from '@yandex-telephony/ya-calls-webphone-sdk';

interface WebphoneEventManagerEvents {
  [WebphoneOutgoingEventKind.NewIncomingCall]?: (event: WebphoneNewIncomingCallEvent) => void;
  [WebphoneOutgoingEventKind.NewOutgoingCall]?: (event: WebphoneNewOutgoingCallEvent) => void;
  [WebphoneOutgoingEventKind.CallEnd]?: (event: WebphoneCallEndEvent) => void;
  [WebphoneOutgoingEventKind.EstablishedCall]?: (event: WebphoneEstablishedCallEvent) => void;
}

export { WebphoneOutgoingEventKind };

export class WebphoneEventManager {
  private webphone: WebphoneWidget;
  private events: WebphoneEventManagerEvents;

  constructor(webphone: WebphoneWidget, events: WebphoneEventManagerEvents = {}) {
    this.webphone = webphone;
    this.events = events;

    this.addEvents();
  }

  private addEvents() {
    Object.entries(this.events).forEach(([event, callback]) => {
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      this.webphone.addEventListener(event as any, callback);
    });
  }

  private removeEvents() {
    Object.entries(this.events).forEach(([event, callback]) => {
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      this.webphone.removeEventListener(event as any, callback);
    });
  }

  public destroy() {
    this.removeEvents();
  }
}
