import { WebphoneWidget } from '@yandex-telephony/ya-calls-webphone-sdk';
import favicon from 'utils/favicon';
import { config } from 'services/Config';
import { WebphoneEventManager, WebphoneOutgoingEventKind } from './WebphoneEventManager';

export class WebphoneFaviconService {
  private manager: WebphoneEventManager;

  constructor(private webphone: WebphoneWidget) {
    this.init();
  }

  public destroy() {
    this.manager.destroy();
  }

  private init() {
    this.manager = new WebphoneEventManager(this.webphone, {
      [config.value.features.useYaCallsLB
        ? WebphoneOutgoingEventKind.EstablishedCall
        : WebphoneOutgoingEventKind.NewIncomingCall]: () => favicon.set(favicon.TYPES.CALL_ACTIVE),
      [WebphoneOutgoingEventKind.CallEnd]: () => favicon.set(favicon.TYPES.DEFAULT),
    });
  }
}
