import { Subscription } from 'rxjs';
import { createRedux } from 'modules/issues/redux';
import { ModuleName } from 'modules/issues/types';
import store from 'store';
import { CallDirection, CallStatus } from 'modules/issues/redux/api/callApi';
import { webphoneIncomingCallService } from './WebphoneIncomingCallService';

export class WebphoneIncomingCallEndService {
  private issueRedux: ReturnType<typeof createRedux>;
  private subscription: Subscription;

  public constructor() {
    this.issueRedux = createRedux(ModuleName.Ticket);

    this.subscription = webphoneIncomingCallService.onCallEnd((data) => {
      store.dispatch(
        this.issueRedux.slices.timelineSlice.asyncActions.saveCall({
          id: data.callId,
          callId: data.ycCallId,
          direction: CallDirection.In,
          status: CallStatus.End,
          issueId: data.issueId,
        }),
      );
    });
  }

  public destroy() {
    this.subscription.unsubscribe();
  }
}
