export interface AcceptCallRequest {
  callId: string;
  remoteNumber: string;
  unitId?: string;
  providerPhoneNumber?: string;
}

export interface AcceptCallResponse {
  id: number;
  typeId: number;
  accountId: number;
  callId: number;
}

export interface AcceptCallData {
  accountId: number;
  issueId: number;
  issueTypeId: number;
  callId: number;
}

export interface IncomingCallEndData {
  ycCallId: string;
  issueId: number;
  callId: number;
}

export type OnCallAcceptSubscription = (payload: AcceptCallData) => void;
export type OnCallEndSubscription = (payload: IncomingCallEndData) => void;
