import { history } from 'appHistory';
import { History } from 'history';
import createLink from 'modules/issues/utils/createLink';
import { WebphoneWidget } from '@yandex-telephony/ya-calls-webphone-sdk';
import { webphoneIncomingCallService } from './WebphoneIncomingCallService';

export class WebphoneIssueRedirectService {
  public constructor(private history: History) {
    webphoneIncomingCallService.onCallAccept((data) => {
      this.history.push(
        createLink({
          id: data.issueId,
          typeId: data.issueTypeId,
          hash: false,
        }),
      );
    });
  }

  public setWebphone(webphone: WebphoneWidget) {
    webphoneIncomingCallService.setWebphone(webphone);
  }
}

export const webphoneIssueRedirectService = new WebphoneIssueRedirectService(history);
