import { logger } from 'services/Logger';
import { WebphoneWidget } from '@yandex-telephony/ya-calls-webphone-sdk';
import { WebphoneEventManager, WebphoneOutgoingEventKind } from './WebphoneEventManager';
import { WebphoneLog } from './WebphoneLog';

export class WebphoneLogger {
  private manager: WebphoneEventManager;

  constructor(private webphone: WebphoneWidget) {
    this.init();
  }

  public destroy() {
    this.manager.destroy();
  }

  private init() {
    this.manager = new WebphoneEventManager(this.webphone, {
      [WebphoneOutgoingEventKind.NewIncomingCall]: this.createHandle('NewIncomingCall'),
      [WebphoneOutgoingEventKind.NewOutgoingCall]: this.createHandle('NewOutgoingCall'),
      [WebphoneOutgoingEventKind.CallEnd]: this.createHandle('CallEnd'),
      [WebphoneOutgoingEventKind.EstablishedCall]: this.createHandle('EstablishedCall'),
    });
  }

  private createHandle(message: string) {
    return (data) => {
      logger.reportInfo(new WebphoneLog(message, data));
    };
  }
}
